<!DOCTYPE html>
<?php
	session_start();
	require 'functions.php';
	$fingerprint = fingerprint();
	$db_link = connect();

	if(isset($_POST['login'])){

		// Include passwort pepper
		require 'config/pepper.php';

		// Sanitize user input
		$log_user = sanitize($db_link, $_POST['log_user']);
		$log_pw = sanitize($db_link, $_POST['log_pw']);

		// Select user details from USER
		$sql_log = "SELECT * FROM user, ugroup WHERE user.ugroup_id = ugroup.ugroup_id AND user_name = '$log_user'";
		$query_log = mysqli_query($db_link, $sql_log);
		checkSQL($db_link, $query_log);
		$result_log = mysqli_fetch_assoc($query_log);

		// Verify Password
		if(password_verify($log_pw.$pepper, $result_log['user_pw'])){

			// Define Session Variables for this User
			$_SESSION['log_user'] = $log_user;
			$_SESSION['log_time'] = time();
			$_SESSION['log_id'] = $result_log['user_id'];
			$_SESSION['log_ugroup'] = $result_log['ugroup_name'];
			$_SESSION['log_admin'] = $result_log['ugroup_admin'];
			$_SESSION['log_delete'] = $result_log['ugroup_delete'];
			$_SESSION['log_report'] = $result_log['ugroup_report'];
			$_SESSION['log_fingerprint'] = $fingerprint;
            $_SESSION['UGroup_id'] = $result_log['ugroup_id'];

			// Check if user logged out properly last time
			$sql_logout = "SELECT logrec_id, logrec_logout FROM logrec WHERE logrec_id IN (SELECT MAX(logrec_id) FROM logrec WHERE user_id = '$_SESSION[log_id]')";
			$query_logout = mysqli_query($db_link, $sql_logout);
			checkSQL($db_link, $query_logout);
			$logout = mysqli_fetch_array($query_logout);
			$_SESSION['logrec_logout'] = $logout[1];

			// Close all open sessions for that user
			$sql_close_logrec = "UPDATE logrec SET logrec_end = '$_SESSION[log_time]' WHERE user_id = '$_SESSION[log_id]' AND logrec_end IS NULL";
			$query_close_logrec = mysqli_query($db_link, $sql_close_logrec);
			checkSQL($db_link, $query_close_logrec);

			// Record Login in LOGREC
			$sql_logrec = "INSERT INTO logrec (user_id, logrec_start, logrec_logout) VALUES ('$_SESSION[log_id]', '$_SESSION[log_time]', '0')";
			$query_logrec = mysqli_query($db_link, $sql_logrec);
			checkSQL($db_link, $query_logrec);

			// Find LOGREC_ID for current user
			$sql_logrecid = "SELECT MAX(logrec_id) FROM logrec WHERE user_id = '$_SESSION[log_id]'";
			$query_logrecid = mysqli_query($db_link, $sql_logrecid);
			checkSQL($db_link, $db_link, $query_logrecid);
			$logrecid = mysqli_fetch_array($query_logrecid);
			$_SESSION['logrec_id'] = $logrecid['MAX(logrec_id)'];

			// Forward to start.php
			header('Location: start.php');
		}
		else showMessage('Authentification failed!\nWrong Username and/or Password!');
	}
?>

<html>
	<?PHP //includeHead('Microfinance Management') ?>
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="robots" content="noindex, nofollow">
        <title>ATC Microfinance</title>
        <link rel="shortcut icon" href="ico/favicon.ico" type="image/x-icon">
        <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Raleway">
        <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.2.0/css/all.css">
        <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.2.0/css/fontawesome.css">
      
        <script>
            $(function() {
                $("#datepicker, #datepicker2, #datepicker3").datepicker({
                    showOtherMonths: true,
                    selectOtherMonths: true,
                    dateFormat: \'dd.mm.yy\',
                    changeMonth: true,
                    changeYear: true
					});
				});
        </script>
    </head>
        <!--
			<form action="login.php" method="post">
							<input type="text" name="log_user"  placeholder="Username" />
					
							<input type="password" name="log_pw" placeholder="Password" />
					
							<input type="submit" name="login" value="Login">
            </form> -->
<style>    
@import url('https://fonts.googleapis.com/css?family=Raleway:400,700');
@import url('https://fonts.googleapis.com/css?family=Cairo');

* {
	box-sizing: border-box;
	margin: 0;
	padding: 0;	
	font-family: Raleway, sans-serif;
}

body {
	background: linear-gradient(90deg, #c7c5f400, #776bcc00);		
     /*height: 100vh; */
}

.container {
	display: flex;
	align-items: center;
	justify-content: center;
	min-height: 100vh;
}

.screen {	/*
   
	background: linear-gradient(90deg, #5D54A4, #7C78B8); */
    background-color: #00a8d3;
	position: relative;
    max-height: 600px;
    max-width: 360px;
    border: 1px solid transparent;
    border-radius: 25px;
/*	height: 600px;
	width: 360px;	*/
	/*box-shadow: 0px 0px 24px #5C5696; */
    margin-left: 50px;
    margin-right: 50px;
}

.screen__content {
	z-index: 1;
	position: relative;	
	/*height: 100%;*/
}

.screen__background {		
	position: absolute;
	top: 0;
	left: 0;
	right: 0;
	bottom: 0;
	z-index: 0;
	-webkit-clip-path: inset(0 0 0 0);
	clip-path: inset(0 0 0 0);	
}

.screen__background__shape {
	/*transform: rotate(45deg);*/
	position: absolute;
}

.login {
	max-width: 320px;
	padding: 30px;
	/*padding-top: 156px;*/
    align-content: center;
}

.login__field {
	padding: 20px 0px;	
	position: relative;	
}
.login__field span{
    font-size: 16px;  
    font-weight: 700;
    color: black;
    }

.login__icon {
	position: absolute;
	top: 68px;
	/*color: #7875B5;*/
    padding-left: 5px;
}

.login__input {
	border: none;
	border-bottom: 2px solid #D1D1D4;
	background: none;
	padding: 10px;
	padding-left: 24px;
	font-weight: 700;
	width: 100%;
	transition: .2s;
}

.login__input:active,
.login__input:focus,
.login__input:hover {
	outline: none;
	border-bottom-color: #6A679E;
}

.login__submit {   
	background: #fff;
	font-size: 16px;
	margin-top: 30px;
	padding: 16px 20px;
	border-radius: 26px;
	border: 1px solid #D4D3E8;
	text-transform: uppercase;
	font-weight: 700;
	/*display: flex;*/
    display: inline-block;
	align-items: center;
	width: 100%;
    color: black;
	/*color: #4C489D;*/
	box-shadow: 0px 2px 2px #5C5696;
	cursor: pointer;
	transition: .2s;
}

.login__submit:active,
.login__submit:focus,
.login__submit:hover {
	border-color: #6A679E;
	outline: none;
}
.companyNameLogin{
    text-align: center; 
    
    font-family: "Cairo";
	color: #FFF;
	display: flex;
	flex-direction: column;
	align-items: center;
	justify-content: center;
	letter-spacing: 1px;
	line-height:2
}
.companyNameLogin .textLogo{
    display: inline-block;    
	text-transform: uppercase;
	font-size: 30px;
	margin: 10px 0px;
    font-weight: 700;
    }
</style> 
        
<body>       
<div class="container">
	<div class="screen">
		<div class="screen__content">
			<form action="login.php" method="post" class="login">
                <div class="companyNameLogin">
                    <span class="textLogo" >Company Name</span>
                </div>
				<div class="login__field">
                    <span>User Name</span><br><br>
					<i class="login__icon fas fa-user"></i>
					<input type="text" class="login__input" name="log_user" placeholder="User name">
				</div>
				<div class="login__field">
                    <span>Password</span><br><br>
					<i class="login__icon fas fa-lock"></i>
					<input type="password" class="login__input" name="log_pw" placeholder="Password">
				</div>
                <!--
				<button class="button login__submit" name="login" >
					<span class="button__text"style="text-align: center;">Log In</span>
				</button> -->
                <input class="login__submit" type="submit" name="login" value="Login">
			</form>
		</div>		
	</div>
</div>
</body>
</html>
